package ru.yandex.webmaster3.viewer.http.user.settings.frontend;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserHostSettingsYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@WriteAction
@Category("user")
@Description("Сохранить настройки пользователя для хоста")
@Slf4j
public class UpdateUserHostSettingsAction extends AbstractUserVerifiedHostAction<UpdateUserHostSettingsRequest, UpdateUserHostSettingsResponse> {
    private FrontendUserHostSettingsYDao frontendUserHostSettingsYDao;


    @Override
    public UpdateUserHostSettingsResponse process(UpdateUserHostSettingsRequest request) {
        try {
            frontendUserHostSettingsYDao.updateValue(
                    request.getUserId(),
                    request.getHostId(),
                    request.getKey(),
                    request.getValue()
            );

            return new UpdateUserHostSettingsResponse();
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to update user host settings",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    @Required
    public void setFrontendUserHostSettingsYDao(FrontendUserHostSettingsYDao frontendUserHostSettingsYDao) {
        this.frontendUserHostSettingsYDao = frontendUserHostSettingsYDao;
    }
}
