package ru.yandex.webmaster3.viewer.http.user.settings.frontend;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserHostSettingsKey;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author avhaliullin
 */
public class UpdateUserHostSettingsRequest extends AbstractUserVerifiedHostRequest {
    private FrontendUserHostSettingsKey key;
    private String value;

    public FrontendUserHostSettingsKey getKey() {
        return key;
    }

    @RequestQueryProperty(required = true)
    @Description("Название ключа настроек")
    public void setKey(FrontendUserHostSettingsKey key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }


    @RequestQueryProperty
    @Description("Записываемое значение")
    public void setValue(String value) {
        this.value = value;
    }
}
