package ru.yandex.webmaster3.viewer.http.user.settings.notification;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class UpdateNotificationEmailResponse implements ActionResponse {
    public static class NormalResponse extends UpdateNotificationEmailResponse implements ActionResponse.NormalResponse {
    }

    public enum Errors {
        UPDATE_NOTIFICATION_EMAIL__NOT_VALIDATED_EMAIL,
    }

    @Description("Переданный email не в списке подтвержденных пользователем email'ов")
    public static class NotValidatedEmailError extends UpdateNotificationEmailResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return Errors.UPDATE_NOTIFICATION_EMAIL__NOT_VALIDATED_EMAIL;
        }
    }
}
