package ru.yandex.webmaster3.viewer.http.user.settings.notification2;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.notifications.NotificationChannel;
import ru.yandex.webmaster3.storage.notifications.service.UserNotificationSettingsService;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;
import ru.yandex.webmaster3.storage.user.notification.UserEmailSettings;
import ru.yandex.webmaster3.storage.user.notification.UserSetEmailInfo;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.user.settings.TwoStateEnableEnum;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
@Description("Посмотреть настройки уведомлений пользователя")
@ReadAction
@Category("notifications")
public class GetUserNotification2SettingsAction extends AbstractUserAction<GetUserNotification2SettingsRequest, GetUserNotification2SettingsResponse> {
    private UserNotificationSettingsService userNotificationSettingsService;

    @Override
    public GetUserNotification2SettingsResponse process(GetUserNotification2SettingsRequest request) {
        try {
            UserEmailSettings emailSettings = userNotificationSettingsService.getEmailSettingsUI(request.getUserId());

            Map<NotificationType, Set<NotificationChannel>> channelsView =
                    userNotificationSettingsService.getDefaultSettings(request.getUserId());

            Map<NotificationType, Map<NotificationChannel, TwoStateEnableEnum>> defaultSettings = new HashMap<>();
            for (Map.Entry<NotificationType, Set<NotificationChannel>> entry : channelsView.entrySet()) {
                Set<NotificationChannel> channels = entry.getValue();
                Map<NotificationChannel, TwoStateEnableEnum> notificationTypeSettings = new EnumMap<>(NotificationChannel.class);
                for (NotificationChannel channel : entry.getKey().getSupportedChannels()) {
                    notificationTypeSettings.put(channel, TwoStateEnableEnum.fromBoolean(channels.contains(channel)));
                }
                defaultSettings.put(entry.getKey(), notificationTypeSettings);
            }

            List<String> verifiedEmails = emailSettings.getVerifiedEmails().stream()
                    .sorted(YANDEX_RU_FIRST)
                    .collect(Collectors.toList());

            UserSetEmailInfo userSetEmailInfo = emailSettings.getEmailInfo();
            String verifiedEmail = userSetEmailInfo.isVerified() ? userSetEmailInfo.getEmail() : null;
            String desiredEmail = userSetEmailInfo.getEmail();
            return new GetUserNotification2SettingsResponse(verifiedEmails, defaultSettings, verifiedEmail, desiredEmail);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to get user notification settings",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    private static final Comparator<String> YANDEX_RU_FIRST = (left, right) -> {
        final String YANDEX_RU = "@yandex.ru";
        boolean isLeftYandexRu = left.endsWith(YANDEX_RU);
        boolean isRightYandexRu = right.endsWith(YANDEX_RU);
        if (isLeftYandexRu && !isRightYandexRu) {
            return -1;
        } else if (!isLeftYandexRu && isRightYandexRu) {
            return +1;
        } else {
            return left.compareTo(right);
        }
    };

    @Required
    public void setUserNotificationSettingsService(UserNotificationSettingsService userNotificationSettingsService) {
        this.userNotificationSettingsService = userNotificationSettingsService;
    }
}
