package ru.yandex.webmaster3.viewer.http.user.settings.notification2;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;

/**
 * @author aherman
 */
public abstract class GetUserNotification2SettingsPerHostResponse implements ActionResponse {
    public static class NormalResponse extends GetUserNotification2SettingsPerHostResponse implements ActionResponse.NormalResponse {
        private final Map<NotificationType, HostNotificationTypeSettings> defaultSettings;
        private final HostSetting hostSettings;
        private final String email;

        public NormalResponse(Map<NotificationType, HostNotificationTypeSettings> defaultSettings, HostSetting hostSettings, String email) {
            this.defaultSettings = defaultSettings;
            this.hostSettings = hostSettings;
            this.email = email;
        }

        @Description("дефолтные настройки типов уведомлений")
        public Map<NotificationType, HostNotificationTypeSettings> getDefaultSettings() {
            return defaultSettings;
        }

        @Description("похостовые настройки типов уведомлений")
        public HostSetting getHostSettings() {
            return hostSettings;
        }

        @Description("email для отправки уведомлений")
        public String getEmail() {
            return email;
        }
    }

    public static class HostNotificationTypeSettings {
        private final String email;
        private final String service;
        private final String sup;

        public HostNotificationTypeSettings(String email,
                                            String service,
                                            String sup) {
            this.email = email;
            this.service = service;
            this.sup = sup;
        }

        @Description("присылать уведомления на почту")
        @JsonProperty("EMAIL")
        public String getEmail() {
            return email;
        }

        @Description("присылать уведомления в сервис")
        @JsonProperty("SERVICE")
        public String getService() {
            return service;
        }

        @Description("присылать уведомления в нотификации")
        @JsonProperty("SUP")
        public String getSup() {
            return sup;
        }
    }

    public static class HostSetting {
        private final WebmasterHostId hostId;
        private final boolean pinned;
        private final Map<NotificationType, HostNotificationTypeSettings> settings;

        public HostSetting(WebmasterHostId hostId, boolean pinned, Map<NotificationType, HostNotificationTypeSettings> settings) {
            this.hostId = hostId;
            this.pinned = pinned;
            this.settings = settings;
        }

        public WebmasterHostId getHostId() {
            return hostId;
        }

        public boolean isPinned() {
            return pinned;
        }

        public Map<NotificationType, HostNotificationTypeSettings> getSettings() {
            return settings;
        }
    }
}
