package ru.yandex.webmaster3.viewer.http.user.settings.notification2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.notifications.NotificationChannel;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;
import ru.yandex.webmaster3.viewer.http.user.settings.TwoStateEnableEnum;

import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class GetUserNotification2SettingsResponse implements ActionResponse.NormalResponse {
    private final List<String> validatedEmails;
    private final Map<NotificationType, Map<NotificationChannel, TwoStateEnableEnum>> defaultSettings;
    private final String email;
    private final String desiredEmail;

    public GetUserNotification2SettingsResponse(List<String> validatedEmails,
                                                Map<NotificationType, Map<NotificationChannel, TwoStateEnableEnum>> defaultSettings,
                                                String email, String desiredEmail) {
        this.validatedEmails = validatedEmails;
        this.defaultSettings = defaultSettings;
        this.email = email;
        this.desiredEmail = desiredEmail;
    }

    @Description("общие и дефолтные настройки типов уведомлений")
    public Map<NotificationType, Map<NotificationChannel, TwoStateEnableEnum>> getDefaultSettings() {
        return defaultSettings;
    }

    @Description("email для отправки уведомлений")
    public String getEmail() {
        return email;
    }

    @Description("Указанный пользователем email, даже если он не подтвержден")
    public String getDesiredEmail() {
        return desiredEmail;
    }

    @Description("провалидированные email'ы, которые можно использовать для получения уведомлений")
    public List<String> getValidatedEmails() {
        return validatedEmails;
    }
}
