package ru.yandex.webmaster3.viewer.http.user.settings.notification2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.user.notification.Setting;

import java.util.List;

/**
 * @author aherman
 */
public abstract class UpdateHostNotification2DefaultSettingResponse implements ActionResponse {
    public static class NormalResponse extends UpdateHostNotification2DefaultSettingResponse implements ActionResponse.NormalResponse {
        private final List<List<Setting>> defaultSettings;

        public NormalResponse(
                List<List<Setting>> defaultSettings)
        {
            this.defaultSettings = defaultSettings;
        }

        public List<List<Setting>> getDefaultSettings() {
            return defaultSettings;
        }
    }

    public enum Errors {
        UPDATE_SETTINGS__NO_EMAIL_WARN,
    }

    @Description("У пользователя не указан email")
    public static class NoEmailWarning extends UpdateHostNotification2DefaultSettingResponse implements ErrorResponse {
        @Override
        public Errors getCode() {
            return Errors.UPDATE_SETTINGS__NO_EMAIL_WARN;
        }
    }
}
