package ru.yandex.webmaster3.viewer.http.user.settings.notification2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.user.notification.HostSetting;

import java.util.List;

/**
 * @author aherman
 */
public abstract class UpdateHostNotification2SettingResponse implements ActionResponse {
    public static class NormalResponse extends UpdateHostNotification2SettingResponse implements ActionResponse.NormalResponse {
        private final List<HostSetting> settings;

        public NormalResponse(List<HostSetting> settings) {
            this.settings = settings;
        }

        public List<HostSetting> getSettings() {
            return settings;
        }
    }

    public enum Errors {
        UPDATE_SETTINGS__NO_EMAIL_WARN,
    }

    @Description("У пользователя не указан email")
    public static class NoEmailWarning extends UpdateHostNotification2SettingResponse implements ErrorResponse {
        @Override
        public Errors getCode() {
            return Errors.UPDATE_SETTINGS__NO_EMAIL_WARN;
        }
    }
}
