package ru.yandex.webmaster3.viewer.http.util;

import java.net.URI;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import org.apache.http.client.methods.HttpGet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.zora.GoZoraService;
import ru.yandex.webmaster3.core.zora.ZoraConversionUtil;
import ru.yandex.webmaster3.core.zora.data.response.ZoraUrlFetchResponse;
import ru.yandex.webmaster3.core.zora.go_data.request.GoZoraRequest;

/**
 * @author leonidrom
 */

@ReadAction
@Category("validation")
@Component("/test/util/goZoraUrlFetch")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GoZoraUrlFetchTestAction extends Action<GoZoraUrlFetchTestAction.Request,
        GoZoraUrlFetchTestAction.Response> {
    private final GoZoraService goZoraService;

    @Override
    public Response process(Request request) throws WebmasterException {
        URI uri = URI.create(request.url);
        var zoraRequest = GoZoraRequest.of(uri.toString());
        HttpGet httpReq = goZoraService.getHttpGetRequest(zoraRequest);
        var response = ZoraConversionUtil.toUrlFetchResponse(goZoraService.executeRequestFetchResponse(zoraRequest));

        return new Response(response, httpReq);
    }

    public static final class Request implements ActionRequest {
        @Setter(onMethod_ = @RequestQueryProperty)
        String url;
    }

    @Value
    public static final class Response implements ActionResponse.NormalResponse {
        ZoraUrlFetchResponse response;
        HttpGet httpReq;
    }
}
