package ru.yandex.webmaster3.viewer.http.util;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import lombok.Getter;

import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.data.HttpResponsePart;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.util.serverresponseutil.model.ServerResponseUtilErrorType;
import ru.yandex.webmaster3.viewer.http.async.model.BaseAsyncInfoErrorType;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 */
public abstract class ServerResponseUtilInfoResponse implements ActionResponse {
    public static class NormalResponse extends ServerResponseUtilInfoResponse implements ActionResponse.NormalResponse {
        private final HttpResponsePart httpResponsePart;
        @Getter
        private final boolean inProgress;

        public NormalResponse(HttpResponsePart httpResponsePart) {
            this.httpResponsePart = httpResponsePart;
            this.inProgress = false;
        }

        public NormalResponse(boolean inProgress) {
            this.httpResponsePart = null;
            this.inProgress = inProgress;
        }


        public static ServerResponseUtilInfoResponse.NormalResponse stillInProgress() {
            return new ServerResponseUtilInfoResponse.NormalResponse(true);
        }

        @JsonUnwrapped
        public HttpResponsePart getHttpResponsePart() {
            return httpResponsePart;
        }
    }

    private static abstract class BaseErrorResponse extends ServerResponseUtilInfoResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        public BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }


    public static class CommonErrorResponse extends ServerResponseUtilInfoResponse.BaseErrorResponse {
        private final ServerResponseUtilErrorType errorType;

        public CommonErrorResponse(Class<?> clazz,ServerResponseUtilErrorType errorType) {
            super(clazz);
            this.errorType = errorType;
        }

        @Override
        public ServerResponseUtilErrorType getCode() {return errorType;}

        @Override
        public String getMessage() {return errorType.getErrorDescription();}
    }
    public static class ExtHttpStatus extends ServerResponseUtilInfoResponse.BaseErrorResponse {
        private final HttpCodeInfo httpCodeInfo;

        public ExtHttpStatus(Class<?> clazz, HttpCodeInfo httpCodeInfo) {
            super(clazz);
            this.httpCodeInfo = httpCodeInfo;
        }

        @Override public ServerResponseUtilErrorType getCode() { return ServerResponseUtilErrorType.SERVER_RESPONSE_TOOL__EXT_HTTP_STATUS; }
        @Override public String getMessage() { return ServerResponseUtilErrorType.SERVER_RESPONSE_TOOL__EXT_HTTP_STATUS.getErrorDescription(); }
        public HttpCodeInfo getHttpCodeInfo() { return httpCodeInfo; }
    }

    public static class RequestIdNotFound extends ServerResponseUtilInfoResponse.BaseErrorResponse {
        public RequestIdNotFound(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_NOT_FOUND;}
        @Override public String getMessage() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_NOT_FOUND.getErrorDescription();}
    }

    public static class RequestStillInProgress extends ServerResponseUtilInfoResponse.BaseErrorResponse {
        public RequestStillInProgress(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_STILL_IN_PROGRESS;}
        @Override public String getMessage() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_STILL_IN_PROGRESS.getErrorDescription();}
    }

    public static class RequestFailed extends ServerResponseUtilInfoResponse.BaseErrorResponse {
        public RequestFailed(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_FAILED;}
        @Override public String getMessage() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__REQUEST_FAILED.getErrorDescription();}
    }

    public static class ResponseDataCorrupted extends ServerResponseUtilInfoResponse.BaseErrorResponse{
        public ResponseDataCorrupted(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__DATA_CORRUPTED;}
        @Override public String getMessage() {return  BaseAsyncInfoErrorType.BASE_ASYNC_INFO__DATA_CORRUPTED.getErrorDescription();}
    }
}
