package ru.yandex.webmaster3.viewer.http.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.UserDataAware;
import ru.yandex.webmaster3.core.worker.task.util.ServerResponseUtilTaskData;
import ru.yandex.webmaster3.core.zora.ZoraUserAgent;
import ru.yandex.webmaster3.storage.util.serverresponseutil.model.ServerResponseUtilInputData;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

import java.util.UUID;

/**
 * @author aherman
 */
public class ServerResponseUtilRequest extends AbstractFrontendRequest implements UserDataAware {
    private String url;
    private String userIp;
    private String yandexUid;
    private String frontendIp;
    private ZoraUserAgent userAgent = ZoraUserAgent.ROBOT;
    private DateTime ifModifiedSince;
    private long userId;

    public long getUserId() {
        return userId;
    }

    @RequestQueryProperty
    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getUrl() {
        return url;
    }

    @Description("Урл страницы")
    @RequestQueryProperty(required = true)
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void setUserIp(String ip) {
        this.userIp = ip;
    }

    public String getUserIp() {
        return userIp;
    }

    @Override
    public void setYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
    }

    public String getYandexUid() {
        return yandexUid;
    }

    @Override
    public void setFrontendIp(String ip) {
        frontendIp = ip;
    }

    public String getFrontendIp() {
        return frontendIp;
    }

    public ZoraUserAgent getUserAgent() {
        return userAgent;
    }

    @Description("Тип User-Agent для запроса")
    @RequestQueryProperty
    public void setUserAgent(ZoraUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public DateTime getIfModifiedSince() {
        return ifModifiedSince;
    }

    @Description("Добавляет заголовок If-Modified-Since к запросу")
    @RequestQueryProperty
    public void setIfModifiedSince(DateTime ifModifiedSince) {
        this.ifModifiedSince = ifModifiedSince;
    }

    @JsonIgnore
    public ServerResponseUtilInputData create() {
        return new ServerResponseUtilInputData(this.url, this.userIp, this.userAgent, this.ifModifiedSince);
    }

    @JsonIgnore
    public ServerResponseUtilTaskData create(UUID taskId) {
        return new ServerResponseUtilTaskData(taskId, this.url, this.userIp, this.userAgent, this.ifModifiedSince);
    }
}
