package ru.yandex.webmaster3.viewer.http.util;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.UUID;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 */
public abstract class StartServerResponseUtilResponse implements ActionResponse {
    public static class NormalResponse extends StartServerResponseUtilResponse implements ActionResponse.NormalResponse {
        private final UUID requestId;

        public NormalResponse(UUID requestId) {
            this.requestId = requestId;
        }

        @Description("id созданной заявки")
        public UUID getRequestId() {
            return requestId;
        }
    }

    public static abstract class AbstractErrorResponse extends StartServerResponseUtilResponse implements ActionResponse.ErrorResponse {
        private final StartServerResponseUtilErrorType errorType;

        public AbstractErrorResponse(StartServerResponseUtilErrorType errorType) {
            this.errorType = errorType;
        }

        @Override
        public Enum<?> getCode() {
            return errorType;
        }
    }

    public static class RequestsLimitExceededErrorResponse extends AbstractErrorResponse {
        public RequestsLimitExceededErrorResponse() {
            super(StartServerResponseUtilErrorType.REQUESTS_LIMIT_EXCEEDED);
        }
    }

    public enum StartServerResponseUtilErrorType {
        REQUESTS_LIMIT_EXCEEDED
    }
}
