package ru.yandex.webmaster3.viewer.http.util;

import java.net.URI;

import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.zora.OfflineZoraService;
import ru.yandex.webmaster3.core.zora.ZoraSourceEnum;
import ru.yandex.webmaster3.core.zora.ZoraUserAgent;
import ru.yandex.webmaster3.core.zora.data.request.ZoraPDFetchRequest;
import ru.yandex.webmaster3.core.zora.data.response.ZoraRawPDFetchResponse;

/**
 * Created by Oleg Bazdyrev on 02/06/2021.
 */

@ReadAction
@Category("internal")
@Component("/test/util/zoraPDFetch")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ZoraPDFetchTestAction extends Action<ZoraPDFetchTestAction.Request, ZoraPDFetchTestAction.Response> {

    private final OfflineZoraService offlineZoraService;

    @Override
    public Response process(Request request) throws WebmasterException {
        URI uri = URI.create(request.url);
        ZoraPDFetchRequest.Builder builder = ZoraPDFetchRequest.builder(uri)
                .source(ZoraSourceEnum.forUserAgent(ZoraUserAgent.BATCH))
                .priority(1L);

        ZoraRawPDFetchResponse urlFetchResponse = offlineZoraService.fetchUrl(builder.build()).getResponse();
        return new Response(urlFetchResponse);
    }

    public static final class Request implements ActionRequest {
        @Setter(onMethod_ = @RequestQueryProperty)
        String url;
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        ZoraRawPDFetchResponse response;
    }

}
