package ru.yandex.webmaster3.viewer.market_compat;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Request;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.uri.WebmasterUriUtils;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author avhaliullin
 */
abstract class AbstractCompatAction {
    abstract Object process(Request request);

    protected String getRequiredStringParam(Request req, String paramName) {
        String value = req.getParameter(paramName);
        if (value == null) {
            throw new MarketCompatErrorException(ErrorResponse.createRequiredParamMissing(paramName));
        }
        return value;
    }

    protected URL prepareUrl(String url) {
        try {
            return WebmasterUriUtils.toOldUri(url).toURL();
        } catch (MalformedURLException | UserException e) {
            throw new IllegalArgumentException(e);
        }
    }
}
