package ru.yandex.webmaster3.viewer.market_compat;

/**
 * @author avhaliullin
 */
public class ErrorResponse {
    public final Errors errors;

    private ErrorResponse(Errors errors) {
        this.errors = errors;
    }

    public static class Errors {
        public final Error error;

        public Errors(Error error) {
            this.error = error;
        }
    }

    public static class Error {
        public final String code;
        //        @JacksonXmlProperty(isAttribute = true, localName = "code")
//        public final int intCode;
        public final String message;
        public final String exception;

        public Error(String code, int intCode, String message, String exception) {
            this.code = code;
//            this.intCode = intCode;
            this.message = message;
            this.exception = exception;
        }
    }

    private static ErrorResponse createFromError(Error error) {
        return new ErrorResponse(new Errors(error));
    }

    public static ErrorResponse createIllegalParamValue(String paramName, String paramValue) {
        return createFromError(new Error("ILLEGAL_PARAM_VALUE", 37, "Illegal value of param " + paramName, "ru.yandex.wmtools.common.error.UserException: " + paramName) {
            public final String param = paramName;
            public final String value = paramValue;
        });
    }

    public static ErrorResponse createRequiredParamMissing(String paramName) {
        return createFromError(new Error("REQUIRED_PARAM_MISSED", 37, "Required param missed: " + paramName, "ru.yandex.wmtools.common.error.UserException: Required param missed: " + paramName) {
            public final String param = paramName;
        });
    }
}
