package ru.yandex.webmaster3.viewer.robotstxt;

import ru.yandex.webmaster3.core.robotstxt.AllowInfo;

/**
 * Url with <code>AllowInfo</code> or with an error.
 *
 * @author ailyin
 */
public class UrlAllowInfo {
    private final String url;
    private final AllowInfo allowInfo;
    private final Error error;

    public UrlAllowInfo(String url, AllowInfo allowInfo) {
        this.url = url;
        this.allowInfo = allowInfo;
        this.error = null;
    }

    public UrlAllowInfo(String url, Error error) {
        this.url = url;
        this.allowInfo = null;
        this.error = error;
    }

    public AllowInfo getAllowInfo() {
        return allowInfo;
    }

    public String getUrl() {
        return url;
    }

    public Error getError() {
        return error;
    }

    public static enum Error {
        ROBOTSTXT_URL_TOO_LONG,
        NO_HOSTNAME,
        URL_SYNTAX_ERROR,
        WRONG_DOMAIN,
        ;
    }
}
