package ru.yandex.webmaster3.viewer.util;

import ru.yandex.webmaster3.core.events2.HostEvent;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventId;
import ru.yandex.webmaster3.core.http.request.RequestIdAware;
import ru.yandex.webmaster3.core.http.request.WebmasterHostIdAware;
import ru.yandex.webmaster3.core.http.request.WebmasterUserIdAware;

/**
 * @author avhaliullin
 */
public class ViewerEventUtil {
    public static <T extends WebmasterHostIdAware & WebmasterUserIdAware & RequestIdAware> HostEvent create(T req, HostEventData data) {
        return HostEvent.create(HostEventId.createFromUserRequest(req.getBalancerRequestId(), req.getUserId()), req.getHostId(), data);
    }
}
