package ru.yandex.webmaster3.viewer.util.suggest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

/**
 * @author avhaliullin
 */
public class SimpleSuggestResultBuilder<T, I> implements SuggestResultBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(SimpleSuggestResultBuilder.class);

    private final int maxResults;
    private final List<T> regions = new ArrayList<>();
    private final Set<I> uniqueIds = new HashSet<>();
    private final Function<T, I> extractor;

    public SimpleSuggestResultBuilder(int maxResults, Function<T, I> extractor) {
        this.maxResults = maxResults;
        this.extractor = extractor;
    }

    public void addAll(String indexName, List<T> newResults, boolean force) {
        for (T item : newResults) {
            if (!force && isComplete()) {
                break;
            }
            if (uniqueIds.add(extractor.apply(item))) {
                log.debug("Added '{}' from index '{}'", item.toString(), indexName);
                regions.add(item);
            }
        }
    }

    public boolean isComplete() {
        return maxResults <= uniqueIds.size();
    }

    public List<T> getRegions() {
        return regions;
    }

}
