package ru.yandex.webmaster3.viewer.util.suggest;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SuggestMetaIndex<T> implements SuggestIndex<T> {
    private final List<SuggestIndex<T>> indexes;

    public SuggestMetaIndex(List<SuggestIndex<T>> indexes) {
        this.indexes = indexes;
    }

    @Override
    public boolean fillResults(String query, SuggestResultBuilder<T> builder) {
        for (SuggestIndex<T> index : indexes) {
            if (index.fillResults(query, builder)) {
                return true;
            }
        }
        return false;
    }
}
