package ru.yandex.webmaster3.viewer.util.suggest;

import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;

/**
 * @author avhaliullin
 */
public interface SuggestResultBuilder<T> {
    void addAll(String indexName, List<T> newResults, boolean force);

    boolean isComplete();

    public static <T, I> SimpleSuggestResultBuilder<T, I> create(int maxResults, Function<T, I> extractor) {
        return new SimpleSuggestResultBuilder<>(maxResults, extractor);
    }

    public static <T> SimpleSuggestResultBuilder<T, T> create(int maxResults) {
        return create(maxResults, UnaryOperator.identity());
    }
}
