package ru.yandex.webmaster3.viewer.video;

import lombok.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.video.OfferStatus;
import ru.yandex.webmaster3.storage.video.VideohostOffer;
import ru.yandex.webmaster3.storage.video.VideohostOfferService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author vsedaikina
 * 18.10.21
 */
@Component("/video/getVideohostOfferStatus")
@ReadAction
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Category("video")
public class GetVideohostOfferStatusAction extends AbstractUserVerifiedHostAction<GetVideohostOfferStatusAction.Req, GetVideohostOfferStatusAction.Res> {
    private final VideohostOfferService videohostOfferService;

    @Override
    public Res process(Req request) {
        VideohostOffer offer = videohostOfferService.getVideohostOffer(request.getHostId());
        return new Res(offer.getStatus(), offer.getOfferUrl(), offer.getComments());
    }

    public static final class Req extends AbstractUserVerifiedHostRequest implements ActionRequest {
    }

    @Value
    @AllArgsConstructor
    public static class Res implements ActionResponse.NormalResponse {
        OfferStatus offerStatus;
        String offerUrl;
        String comment;
    }
}
