package ru.yandex.webmaster3.viewer.video;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.video.VideohostOfferService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author vsedaikina
 * 21.10.21
 */
@Component("/video/removeVideohostOffer")
@WriteAction
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Category("video")
public class RemoveVideohostOfferAction extends AbstractUserVerifiedHostAction<RemoveVideohostOfferAction.Req, RemoveVideohostOfferAction.Res> {
    private final VideohostOfferService videohostOfferService;

    @Override
    public Res process(Req request) {
        //assume that there is only one offer for each host
        videohostOfferService.removeVideohostOffer(request.getHostId());
        return new Res();
    }

    public static final class Req extends AbstractUserVerifiedHostRequest implements ActionRequest {
    }

    public static final class Res implements ActionResponse.NormalResponse {

    }
}
