package ru.yandex.webmaster3.worker;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.worker.client.WorkerClient;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.worker.queue.TaskQueueService;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

/**
 * @author aherman
 */
public class LocalWorkerClient implements WorkerClient {
    private static final Logger log = LoggerFactory.getLogger(LocalWorkerClient.class);

    private TaskQueueService taskQueueService;
    private Map<WorkerTaskType, Task> registeredTasks = Collections.emptyMap();

    @Override
    public <TD extends WorkerTaskData> void enqueueTask(TD taskData){
        Task task = registeredTasks.get(taskData.getTaskType());
        if (task == null) {
            log.error("Unknown task type: {}", taskData.getTaskType());
            return;
        }

        taskQueueService.enqueueTask(taskData);
    }

    @Override
    public <TD extends WorkerTaskData> boolean checkedEnqueueTask(TD taskData){
        Task task = registeredTasks.get(taskData.getTaskType());
        if (task == null) {
            log.error("Unknown task type: {}", taskData.getTaskType());
            return false;
        }

        return taskQueueService.enqueueTask(taskData);
    }

    @Required
    public void setRegisteredTasks(Map<WorkerTaskType, Task> registeredTasks) {
        this.registeredTasks = new EnumMap<>(WorkerTaskType.class);
        this.registeredTasks.putAll(registeredTasks);
    }

    @Required
    public void setTaskQueueService(TaskQueueService taskQueueService) {
        this.taskQueueService = taskQueueService;
    }
}
