package ru.yandex.webmaster3.worker;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.worker.queue.TaskQueueMetrics;

/**
 * Лимитирует кол-во запущенных одновременно задач нужного типа
 * @author Oleg Bazdyrev
 */
public abstract class ProcessingCountLimitedTask<TD extends WorkerTaskData> extends Task<TD> {

    private int maxProcessing;

    public int getMaxProcessing() {
        return maxProcessing;
    }

    @Required
    public void setMaxProcessing(int maxProcessing) {
        this.maxProcessing = maxProcessing;
    }

    @Override
    public float getPriority(TaskQueueMetrics.TaskStatistics stats) {
        if (maxProcessing > stats.getProcessing()) {
            return super.getPriority(stats);
        }
        return 0.0f;
    }
}
