package ru.yandex.webmaster3.worker;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.worker.queue.TaskQueueMetrics;

/**
 * @author aherman
 */
public abstract class RpsLimitedTask<TD extends WorkerTaskData> extends Task<TD> {
    private float targetRps;

    @Required
    public void setTargetRps(float targetRps) {
        this.targetRps = targetRps;
    }

    public float getTargetRps() {
        return targetRps;
    }

    @Override
    public float getPriority(TaskQueueMetrics.TaskStatistics stats) {
        return Math.max(1f - (stats.getInstantLaunchRps() * 1f) / targetRps, 0);
    }
}
