package ru.yandex.webmaster3.worker;

import java.util.Collections;
import java.util.List;

import ru.yandex.webmaster3.core.tracer.YdbTracer;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.worker.queue.TaskQueueMetrics;

/**
 * @author aherman
 */
public abstract class Task<TD extends WorkerTaskData> {

    public Result runWithTracer(TD data) throws Exception {
        return YdbTracer.trace(data.getTaskType().name(), () -> run(data));
    }

    public abstract Result run(TD data) throws Exception;

    public abstract Class<TD> getDataClass();

    public static class Result {
        public static Result SUCCESS = new Result(TaskResult.SUCCESS);
        public static Result FAIL = new Result(TaskResult.FAIL);

        private final TaskResult taskResult;
        private final List<WorkerTaskData> followingTasks;

        public Result(TaskResult taskResult, List<WorkerTaskData> followingTasks) {
            this.taskResult = taskResult;
            this.followingTasks = followingTasks;
        }

        public Result(TaskResult taskResult) {
            this.taskResult = taskResult;
            this.followingTasks = Collections.emptyList();
        }

        public TaskResult getTaskResult() {
            return taskResult;
        }

        public List<WorkerTaskData> getFollowingTasks() {
            return followingTasks;
        }
    }

    public Integer getMaxQueueSize() {
        return null;
    }

    public float getPriority(TaskQueueMetrics.TaskStatistics stats) {
        float estimateTaskRunTime = 1.0f * Math.abs(stats.getEnqueueed() * stats.getAverageRunTimsMs());
        return 1.0F / ((float) Math.log1p(estimateTaskRunTime) + 1.0F);
    }
}
