package ru.yandex.webmaster3.worker;

import org.intellij.lang.annotations.Pattern;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

/**
 * @author aherman
 */
public abstract class TaskSchedule {
    public static TaskSchedule startByCron(
            @Pattern("([0-9\\*,/-]+ ){4}" +
                    "([0-9\\*,/-]|FOO|JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)+ " +
                    "([0-9\\*,/-]|SUN|MON|TUE|WED|THU|FRI|SAT)+")
            final String cronExpression) {
        return new TaskSchedule() {
            @Override
            Trigger getTrigger() {
                return new CronTrigger(cronExpression);
            }

            @Override
            public String toString() {
                return "cron " + cronExpression;
            }
        };
    }

    public static TaskSchedule never() {
        return new TaskSchedule() {
            @Override
            Trigger getTrigger() {
                return null;
            }

            @Override
            public String toString() {
                return "never";
            }
        };
    }

    abstract Trigger getTrigger();
}
