package ru.yandex.webmaster3.worker.achievements;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

import ru.yandex.webmaster3.storage.achievements.dao.AchievementsCHDao.F;
import ru.yandex.webmaster3.storage.clickhouse.TableType;
import ru.yandex.webmaster3.storage.util.clickhouse2.AbstractClickhouseDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHPrimitiveType;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHTable;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Created by Oleg Bazdyrev on 16/01/2019.
 */
public class ImportAchievementsKuubTask extends ImportAchievementsTask {

    private static final CHTable TABLE = CHTable.builder()
            .database(AbstractClickhouseDao.DB_WEBMASTER3)
            .name("achievements_kuub_%s")
            .sharded(false)
            .partitionBy("toYYYYMM(date)")
            .keyField("date", CHPrimitiveType.Date)
            .keyField(F.OWNER, CHPrimitiveType.String)
            .keyField(F.TLD, CHPrimitiveType.String)
            .field(F.USER_SELECTION, CHPrimitiveType.UInt8)
            .field(F.POPULAR, CHPrimitiveType.UInt8)
            .field(F.OFFICIAL_GOV, CHPrimitiveType.UInt8)
            .field(F.OFFICIAL_YANDEX, CHPrimitiveType.UInt8)
            .field(F.OFFICIAL_AUTO, CHPrimitiveType.UInt8)
            .field(F.SERVICE_CENTER, CHPrimitiveType.String)
            .field(F.BRANDS, CHPrimitiveType.String)
            .field(F.UNSAFE_HOST, CHPrimitiveType.UInt8)
            .field(F.OFFICIAL_AIRLINE, CHPrimitiveType.UInt8)
            .field(F.OFFICIAL_EMBASSY, CHPrimitiveType.UInt8)
            .field(F.OFFICIAL_VISA_CENTER, CHPrimitiveType.UInt8)
            .field(F.TAS_IX, CHPrimitiveType.UInt8)
            .field(F.HTTPS, CHPrimitiveType.UInt8)
            .field(F.TURBO_WM,CHPrimitiveType.UInt8)
            .field(F.VIDEOHOST_RATING, CHPrimitiveType.Int64)
            .build();

    private static final Map<String, String> SOURCE_EXPRESSIONS = new ImmutableMap.Builder<String, String>()
            .put(F.OWNER, "MascotOwner")
            .put(F.TLD, "Tld")
            .put(F.USER_SELECTION, "cast(nvl(UserSelection, 0) as String)")
            .put(F.POPULAR, "cast(nvl(Popular, 0) as String)")
            .put(F.OFFICIAL_GOV, "if(Official, '1', '0')")
            .put(F.OFFICIAL_AUTO, "if(OfficialAuto is not null, '1', '0')")
            .put(F.SERVICE_CENTER, "String::EscapeC(nvl(ServiceCenter, ''))")
            .put(F.BRANDS, "String::EscapeC(nvl(Brands, ''))")
            .put(F.UNSAFE_HOST, "'0'")
            .put(F.OFFICIAL_AIRLINE, "if(OfficialAvia, '1', '0')")
            .put(F.OFFICIAL_EMBASSY, "if(OfficialEmbassy, '1', '0')")
            .put(F.OFFICIAL_VISA_CENTER, "if(OfficialVisaCenter, '1', '0')")
            .put(F.OFFICIAL_YANDEX, "if(OfficialYandex, '1', '0')")
            .put(F.TAS_IX, "if(Tasix, '1', '0')")
            .put(F.HTTPS, "if(Https == true, '1', if (Https == false, '2', '0'))")
            .put(F.TURBO_WM,"if(TurboWm, '1', '0')")
            .put(F.VIDEOHOST_RATING, "cast(nvl(VideohostRating, -1) as String)")
            .build();

    @Override
    protected Map<String, String> getSourceExpressions() {
        return SOURCE_EXPRESSIONS;
    }

    @Override
    protected CHTable getTable() {
        return TABLE;
    }

    @Override
    protected TableType getTableType() {
        return TableType.ACHIEVEMENTS_KUUB;
    }

    @Override
    protected YtClickhouseDataLoadType getImportType() {
        return YtClickhouseDataLoadType.ACHIEVEMENTS_KUUB;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 18 * * * *");
    }

}
