package ru.yandex.webmaster3.worker.antispam.threats;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.antispam.threats.CheckForHostThreatsTaskData;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.antispam.threats.dao.HostThreatForceRecheckQueueYDao;
import ru.yandex.webmaster3.storage.antispam.threats.dao.OwnerThreatsCHDao;
import ru.yandex.webmaster3.worker.Task;

/**
 * Таска формирования угроз для вновь добавленных сайтов
 * Created by Oleg Bazdyrev on 09/08/2017.
 */
@Slf4j
@Category("threats")
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class CheckForHostThreatsTask extends Task<CheckForHostThreatsTaskData> {

    private final HostThreatForceRecheckQueueYDao hostThreatForceRecheckQueueYDao;
    private final OwnerThreatsCHDao mdbOwnerThreatsCHDao;

    @Override
    public Result run(CheckForHostThreatsTaskData data) throws Exception {
        WebmasterHostId mainHostId = data.getHostId();
        log.info("Checking for host threats recently added host: {}", mainHostId.toStringId());
        OwnerThreatsCHDao.@NotNull HostThreats hostWithThreats = mdbOwnerThreatsCHDao.getHostWithThreats(mainHostId);

        // если, что-то есть, надо сохранить угрозы
        if (!hostWithThreats.getThreats().isEmpty()) {
            // отгружаем этот хост в стандартный контур для форсированного обхода
            hostThreatForceRecheckQueueYDao.insertHost(mainHostId);
        }
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public Class<CheckForHostThreatsTaskData> getDataClass() {
        return CheckForHostThreatsTaskData.class;
    }
}
