package ru.yandex.webmaster3.worker.antispam.threats;

import java.util.UUID;

import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.antispam.threats.dao.HostThreatForceRecheckQueueYDao;
import ru.yandex.webmaster3.storage.util.yt.YtException;
import ru.yandex.webmaster3.storage.util.yt.YtNode;
import ru.yandex.webmaster3.storage.util.yt.YtNodeAttributes;
import ru.yandex.webmaster3.storage.util.yt.YtPath;
import ru.yandex.webmaster3.storage.util.yt.YtService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Created by Oleg Bazdyrev on 10/08/2017.
 */
@AllArgsConstructor(onConstructor_ = @Autowired)
@Service
public class ExportThreatForceRechecksTask extends PeriodicTask<PeriodicTaskState> {

    private final HostThreatForceRecheckQueueYDao hostThreatForceRecheckQueueYDao;
    private final YtService ytService;
    @Value("${webmaster3.worker.threatsExport.force.ytPath}")
    private final YtPath tablePath;

    @Override
    public Result run(UUID runId) throws Exception {
        // просто сливаем в таблицу все содержимое очереди из кассандры
        ytService.inTransaction(tablePath).execute(cypressService -> {
            // создадим табличку
            cypressService.create(tablePath, YtNode.NodeType.TABLE, true, new YtNodeAttributes(), true);
            cypressService.writeTable(tablePath, tableWriter -> hostThreatForceRecheckQueueYDao.forEachHost(hostId -> {
                try {
                    tableWriter.column("host", IdUtils.hostIdToUrl(hostId));
                    tableWriter.rowEnd();
                } catch (YtException e) {
                    throw new WebmasterException("Error writing to YT",
                            new WebmasterErrorResponse.YTServiceErrorResponse(getClass(), e), e);
                }
            }));
            return true;
        });

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.EXPORT_THREAT_FORCE_RECHECKS;
    }

    @Override
    public TaskSchedule getSchedule() {
        // два раза в день
        return TaskSchedule.startByCron("0 31 4/12 * * *");
    }
}
