package ru.yandex.webmaster3.worker.checklist;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

import java.util.UUID;

public class FollowMordaRedirectsTaskData extends WorkerTaskData {
    public FollowMordaRedirectsTaskData(WebmasterHostId hostId) {
        super(hostId, WorkerTaskPriority.LOW);
    }

    protected FollowMordaRedirectsTaskData(@JsonProperty("taskId") UUID taskId, @JsonProperty("hostId") WebmasterHostId hostId) {
        super(taskId, hostId);
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.FOLLOW_MORDA_REDIRECTS;
    }

    @Override
    public String getShortDescription() {
        return null;
    }
}