package ru.yandex.webmaster3.worker.dashboard;

import java.util.Comparator;
import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.clickhouse.ClickhouseTableInfo;
import ru.yandex.webmaster3.storage.clickhouse.dao.LegacyClickhouseTablesYDao;

@Component("/tableInfo/list")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ListTablesAction extends Action<ListTablesAction.Request, ListTablesAction.Response> {
    private final LegacyClickhouseTablesYDao legacyClickhouseTablesYDao;

    @Override
    public Response process(Request request) throws WebmasterException {
        final List<ClickhouseTableInfo> tableInfos = legacyClickhouseTablesYDao.listTables();
        tableInfos.sort(Comparator
                .comparing(ClickhouseTableInfo::getType, Comparator.comparing(Enum::name))
                .thenComparing(Comparator.comparing(ClickhouseTableInfo::getUpdateDate).reversed()));
        return new Response(tableInfos);
    }

    public static class Request implements ActionRequest {

    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        private final List<ClickhouseTableInfo> tableInfos;
    }
}
