package ru.yandex.webmaster3.worker.dashboard.notifications;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import lombok.Value;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.storage.user.message.MessageTypeEnum;

@ReadAction
@Component("/notifications/types")
public class GetMessageTypesAndProblemsAction extends Action<GetMessageTypesAndProblemsAction.Request, GetMessageTypesAndProblemsAction.Response> {


    @Override
    public Response process(Request request) throws WebmasterException {
        final var values = Arrays.stream(SiteProblemTypeEnum.values()).map(Enum::name).collect(Collectors.toList());
        values.add("");
        values.sort(String::compareTo);
        return new Response(MessageTypeEnum.values(), values);
    }

    public static class Request implements ActionRequest {

    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        MessageTypeEnum[] types;
        List<String> problems;
    }
}
