package ru.yandex.webmaster3.worker.dashboard.notifications;

import java.util.Objects;

import lombok.Value;

import ru.yandex.webmaster3.storage.user.message.MessageTypeEnum;

@Value
public class MessageInfo {
    private MessageTypeEnum type;
    private String problem;
    private boolean enabled;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessageInfo that = (MessageInfo) o;
        return type == that.type &&
                Objects.equals(problem, that.problem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, problem);
    }
}
