package ru.yandex.webmaster3.worker.dashboard.notifications;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.Getter;
import lombok.Setter;
import lombok.Value;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.host.CommonDataState;
import ru.yandex.webmaster3.storage.host.CommonDataType;
import ru.yandex.webmaster3.storage.settings.dao.CommonDataStateYDao;
import ru.yandex.webmaster3.storage.user.message.MessageTypeEnum;

@WriteAction
@Component("/blocked/notifications/add")
public class SetBlockedNotificationsAction extends Action<SetBlockedNotificationsAction.Request, SetBlockedNotificationsAction.Response> {

    @Autowired
    private CommonDataStateYDao commonDataStateYDao;

    @Override
    public Response process(Request request) throws WebmasterException {
        if (request.getMessageInfos().isEmpty()) {
            final CommonDataState data = commonDataStateYDao.createData(CommonDataType.BLOCKED_MESSAGE_TYPES, "", DateTime.now());
            commonDataStateYDao.update(data);
            return new Response();
        }
        String typesWithoutChecklistChanges = request.getMessageInfos().stream()
                .filter(MessageInfo::isEnabled)
                .filter(x -> x.getType() != MessageTypeEnum.CHECKLIST_CHANGES)
                .map(MessageInfo::getType)
                .map(Enum::toString)
                .collect(Collectors.joining(";"));
        final Set<MessageInfo> checklistChangesInfos = request.getMessageInfos().stream()
                .filter(MessageInfo::isEnabled)
                .filter(x -> x.getType() == MessageTypeEnum.CHECKLIST_CHANGES)
                .collect(Collectors.toSet());

        String typeChecklistChanges = null;
        if (!checklistChangesInfos.isEmpty()) {

            if (checklistChangesInfos.contains(new MessageInfo(MessageTypeEnum.CHECKLIST_CHANGES, "", true))) {
                typeChecklistChanges = MessageTypeEnum.CHECKLIST_CHANGES.toString();
            } else {
                typeChecklistChanges = MessageTypeEnum.CHECKLIST_CHANGES.toString() + ',' +
                        checklistChangesInfos.stream().map(MessageInfo::getProblem).collect(Collectors.joining(","));
            }
        }
        String blockedTypes;
        if (!typesWithoutChecklistChanges.isBlank() && typeChecklistChanges != null) {
            blockedTypes = typesWithoutChecklistChanges + ";" + typeChecklistChanges;
        } else {
            if (typesWithoutChecklistChanges.isBlank()) {
                blockedTypes = typeChecklistChanges;
            } else {
                blockedTypes = typesWithoutChecklistChanges;
            }
        }
        final CommonDataState data = commonDataStateYDao.createData(CommonDataType.BLOCKED_MESSAGE_TYPES, blockedTypes, DateTime.now());
        commonDataStateYDao.update(data);
        return new Response();
    }

    @Setter(onMethod_ = @RequestQueryProperty)
    @Getter
    public static class Request implements ActionRequest {
        private List<MessageInfo> messageInfos;
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
    }

}
