package ru.yandex.webmaster3.worker.digest;

import com.datastax.driver.core.utils.UUIDs;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.storage.notifications.NotificationRecListId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class DigestNotificationUtil {
    public static LocalDate getDigestDate(UUID notificationId) {
        return new Instant(UUIDs.unixTimestamp(notificationId)).toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toLocalDate();
    }

    public static LocalDate getDigestDate(NotificationRecListId recListId) {
        return getDigestDate(recListId.getNotificationId());
    }

    public static UUID getNotificationId(LocalDate digestDate) {
        return UUIDs.startOf(digestDate.toDateTimeAtStartOfDay(TimeUtils.EUROPE_MOSCOW_ZONE).getMillis());
    }

    public static NotificationRecListId getRecListId(LocalDate digestDate) {
        UUID uuid = getNotificationId(digestDate);
        return new NotificationRecListId(uuid, uuid);
    }

}
