package ru.yandex.webmaster3.worker.digest.blog;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Range;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.worker.digest.html.DigestData;

import java.util.*;
import java.util.function.Consumer;
import java.util.stream.Stream;

/**
 * Created by ifilippov5 on 21.11.17.
 */
public class WebmasterBlogPostUtil {
    private static final String POST_TAG = "%D0%BD%D0%BE%D0%B2%D0%BE%D1%81%D1%82%D1%8C"; //новость

    public static void parseBlogPost(JsonNode node, Range<LocalDate> datesInterval, Consumer<DigestData.BlogPost> consumer) {
        DigestData.BlogPost blogPost = parseFromJson(node);

        Stream.of(blogPost)
                .filter(post -> datesInterval.contains(post.getDate().toLocalDate()))
                .forEach(consumer);
    }

    public static String tagInQuery() {
        return "tagSlug=" + POST_TAG;
    }

    private static DigestData.BlogPost parseFromJson(JsonNode node) {
        return new DigestData.BlogPost(
                node.get("slug").asText(),
                node.get("approvedTitle").asText(),
                DateTime.parse(node.get("publishDate").asText()).toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE)
        );
    }
}
