package ru.yandex.webmaster3.worker.digest.html;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;

import java.util.List;
import java.util.function.Function;

/**
 * Created by ifilippov5 on 22.09.17.
 */
public class ArrayNodeWrapper {
    public ArrayNode arrayNode;

    private ArrayNodeWrapper() {
        arrayNode = JsonNodeFactory.instance.arrayNode();
    }

    public ArrayNodeWrapper add(JsonNodeWrapper value) {
        arrayNode.add(value.getNode());
        return this;
    }

    public ArrayNodeWrapper add(JsonNode value) {
        arrayNode.add(value);
        return this;
    }

    public ArrayNodeWrapper add(String value) {
        arrayNode.add(value);
        return this;
    }

    public ArrayNodeWrapper add(ArrayNodeWrapper array) {
        array.getNode().forEach(this::add); //TODO test
        return this;
    }

    public ArrayNodeWrapper addAll(List<String> list, Function<String, JsonNodeWrapper> func) {
        for (String str : list) {
            add(func.apply(str));
        }
        return this;
    }

    public ArrayNodeWrapper addAllSamples(List<DigestData.Searchable.Sample> samples, Function<DigestData.Searchable.Sample, JsonNodeWrapper> func) {
        for (DigestData.Searchable.Sample sample : samples) {
            add(func.apply(sample));
        }
        return this;
    }

    public ArrayNodeWrapper addAllQueries(List<DigestData.Queries.QData> queries, Function<DigestData.Queries.QData, JsonNodeWrapper> func) {
        for (DigestData.Queries.QData query : queries) {
            add(func.apply(query));
        }
        return this;
    }

    public ArrayNodeWrapper addAllQueriesGroups(List<DigestData.QueriesGroups.QDataGroups> queries, Function<DigestData.QueriesGroups.QDataGroups, JsonNodeWrapper> func) {
        for (DigestData.QueriesGroups.QDataGroups query : queries) {
            add(func.apply(query));
        }
        return this;
    }


    public ArrayNode getNode() {
        return arrayNode;
    }

    public static ArrayNodeWrapper create() {
        return new ArrayNodeWrapper();
    }
}
