package ru.yandex.webmaster3.worker.digest.html;

import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;
import ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusEnum;
import ru.yandex.webmaster3.tanker.*;
import ru.yandex.webmaster3.tanker.digest.html.HtmlNode;

/**
 * Created by ifilippov5 on 25.09.17.
 */
public class DigestI18n {
    private static final String LOGO_LINK_EN = "https://yastatic.net/s3/webmaster/webmaster/logo/webmaster-lang-en-white.png";
    private static final String LOGO_LINK_RU = "https://yastatic.net/s3/webmaster/webmaster/logo/webmaster-lang-ru-white.png";

    public final LanguageEnum language;

    public DigestI18n(LanguageEnum language) {
        this.language = language;
    }


    public HtmlNode getDigestTitle(HtmlNode hostLink) {
        return I18nDigestDynamic.HTML_dynamic_digest_title.newBuilder(language)
                .host(hostLink);
    }

    public String getDigestLogoText() {
        return I18nDigest.logo
                .getText(language);
    }

    public String getChecklistProblems() {
        return I18nDigestChecklist.problems
                .getText(language);
    }

    public String getChecklistChecks() {
        return I18nDigestChecklist.checks
                .getText(language);
    }

    public String getSearchableLink() {
        return I18nDigestSearchable.link
                .getText(language);
    }

    public String getSearchableAdded(String added) {
        return I18nDigestSearchable.added
                .newBuilder(language)
                .count(added)
                .render();
    }

    public String getSearchableRemoved(String removed) {
        return I18nDigestSearchable.removed
                .newBuilder(language)
                .count(removed)
                .render();
    }

    public String getSearchableTableUrl() {
        return I18nDigestSearchable.table__url
                .getText(language);
    }

    public String getSearchableTableReason() {
        return I18nDigestSearchable.table__reason
                .getText(language);
    }

    public String getSearchableTableStatus() {
        return I18nDigestSearchable.table__status
                .getText(language);
    }

    public String getSearchableStatusAdded() {
        return I18nDigestSearchable.status__added
                .getText(language);
    }

    public String getSearchableStatusRemoved() {
        return I18nDigestSearchable.status__removed
                .getText(language);
    }

    public String getSearchable(DigestData.StatsEnum status) {
        return status == DigestData.StatsEnum.ADDED ? getSearchableStatusAdded() : getSearchableStatusRemoved();
    }

    public String getQueriesTitle() {
        return I18nDigestQueries.title
                .getText(language);
    }

    public String getQueriesTableClicks() {
        return I18nDigestQueries.table__clicks
                .getText(language);
    }

    public String getQueriesTableDifference() {
        return I18nDigestQueries.table__difference
                .getText(language);
    }

    public String getQueriesLink() {
        return I18nDigestQueries.link
                .getText(language);
    }

    public String getQueriesGroupsTitle() {
        return I18nDigestQueriesGroups.title
                .getText(language);
    }

    public String getQueriesGroupsTableClicks() {
        return I18nDigestQueriesGroups.table__clicks
                .getText(language);
    }

    public String getQueriesGroupsTableDifference() {
        return I18nDigestQueriesGroups.table__difference
                .getText(language);
    }

    public String getQueriesGroupsLink() {
        return I18nDigestQueriesGroups.link
                .getText(language);
    }

    public HtmlNode getFooterViewChanges(HtmlNode dashboardLink) {
        return I18nDigestDynamic.HTML_dynamic_footer_viewchanges.newBuilder(language)
                .dashboardLink(dashboardLink);
    }

    public String getFooterInSettings() {
        return I18nDigestFooter.insettings
                .getText(language);
    }

    public String getFooterEnd() {
        return I18nDigestFooter.end
                .getText(language);
    }

    public String getFooterInSummary() {
        return I18nDigestFooter.insummary
                .getText(language);
    }

    public HtmlNode getFooterManageSubscriptions(HtmlNode settingsLink) {
        return I18nDigestDynamic.HTML_dynamic_footer_managesubscriptions.newBuilder(language)
                .settingsLink(settingsLink);
    }

    public String getClicksDifferenceZero() {
        return I18nDigestClicks.difference_zero
                .getText(language);
    }

    public String getClicksDifferenceNegative(String count) {
        return I18nDigestClicks.difference_negative
                .newBuilder(language)
                .count(count)
                .render();
    }

    public String getClicksDifferencePositive(String count) {
        return I18nDigestClicks.difference_positive
                .newBuilder(language)
                .count(count)
                .render();
    }

    public String getClicksDifference(int sign, String difference) {
        switch (sign) {
            case 0:
                return getClicksDifferenceZero();
            case -1:
                return getClicksDifferenceNegative(difference);
            case 1:
                return getClicksDifferencePositive(difference);
        }
        return "";
    }

    public String getSearchableReason(SearchUrlStatusEnum searchUrlStatusEnum) {
        return I18nHttpCodeStatusTitle.fromEnum(searchUrlStatusEnum)
                .newBuilder(language)
                .httpCode(null)
                .render();
    }

    public String getSpecialGroupName(SpecialGroup specialGroup){
        return I18nSpecialQueriesGroup.fromEnum(specialGroup).getText(language);
    }

    public String getPagesCountsDifferenceZero() {
        return I18nDigestClicks.difference_zero
                .getText(language);
    }

    public String getImportantPagesText() {
        return I18nDigestPageTypeNames.important_name
                .getText(language);
    }

    public String getImportantPagesLanding() {
        return I18nDigestPageTypeNames.important_landing
                .getText(language);
    }

    public String getRecommendedPagesText() {
        return I18nDigestPageTypeNames.recommended_name
                .getText(language);
    }

    public String getRecommendedPagesLanding() {
        return I18nDigestPageTypeNames.recommended_landing
                .getText(language);
    }

    public String getRecommendedPagesLandingFew() {
        return I18nDigestPageTypeNames.recommended_landing_few
                .getText(language);
    }

    public String getRecommendedShowsText() {
        return I18nDigestRecommendedTexts.shows_text
                .getText(language);
    }

    public String getRecommendedClicksText() {
        return I18nDigestRecommendedTexts.clicks_text
                .getText(language);
    }

    public String getImportantCodeText() {
        return I18nDigestImportantTexts.code_text
                .getText(language);
    }

    public String getImportantStatusText() {
        return I18nDigestImportantTexts.status_text
                .getText(language);
    }

    public String getLogoLink() {
        if (language == LanguageEnum.EN || language == LanguageEnum.TR) {
            return LOGO_LINK_EN;
        } else {
            return LOGO_LINK_RU;
        }
    }

    public String getBlogTitle() {
        return I18nDigestBlog.title
                .getText(language);
    }

    public String getForcedAllSites() {
        return I18nDigestTemp.allsites
                .getText(language);
    }

    public String getForcedSomeSites() {
        return I18nDigestTemp.somesites
                .getText(language);
    }
}
