package ru.yandex.webmaster3.worker.digest.html;

import java.util.ArrayList;
import java.util.List;

import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.springframework.web.util.UriComponentsBuilder;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.notifications.EmailTrackingInfo;

public class DigestTrackingInfo extends EmailTrackingInfo {
    private final List<DigestBlockType> digestBlockTypes;

    public DigestTrackingInfo(@Nullable WebmasterHostId hostId, List<DigestBlockType> digestBlockTypes, long userId, String messageType, DateTime dateTime) {
        super(hostId, userId, messageType, dateTime);

        this.digestBlockTypes = digestBlockTypes;
    }

    public List<byte[]> getDataAsBytes() {
        List<byte[]> result = new ArrayList<>(super.getDataAsBytes());
        result.add(getBytes(digestBlockTypes));

        return result;
    }

    @Override
    public void addToQueryParams(UriComponentsBuilder builder) {
       super.addToQueryParams(builder);

       builder.queryParam("digest_blocks", digestBlockTypes);
    }
}
