package ru.yandex.webmaster3.worker.digest.html;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.sql.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;

/**
 * Created by ifilippov5 on 22.09.17.
 */
public class JsonNodeWrapper {
    public ObjectNode objectNode;

    private JsonNodeWrapper() {
        objectNode = JsonNodeFactory.instance.objectNode();
    }

    public JsonNodeWrapper put(String fieldName, int value) {
        objectNode =  objectNode.put(fieldName, value);
        return this;
    }

    public JsonNodeWrapper put(String fieldName, String value) {
        objectNode = objectNode.put(fieldName, value);
        return this;
    }

    public JsonNodeWrapper put(String fieldName, ObjectNode value) {
        objectNode.set(fieldName, value);
        return this;
    }

    public JsonNodeWrapper put(String fieldName, ArrayNodeWrapper value) {
        objectNode.set(fieldName, value.getNode());
        return this;
    }

    public JsonNodeWrapper put(String fieldName, JsonNodeWrapper value) {
        objectNode.set(fieldName, value.getNode());
        return this;
    }

    public String get(String fieldName) {
        return objectNode.get(fieldName).asText();
    }

    public ObjectNode getNode() {
        return objectNode;
    }

    public static JsonNodeWrapper create() {
        return new JsonNodeWrapper();
    }
}
