package ru.yandex.webmaster3.worker.digest.notificationsettings;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.solomon.SolomonPushAPIService;
import ru.yandex.webmaster3.core.solomon.SolomonSensor;
import ru.yandex.webmaster3.core.solomon.metric.SolomonCommonLabels;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
public class UserNotificationSettingsMetricsService {

    private SolomonPushAPIService solomonPushAPIService;
    private SolomonCommonLabels commonLabels;
    private String project;
    private String cluster;
    private String service;
    private String host;

    public void init() {
        commonLabels = new SolomonCommonLabels(project, service, cluster,host);
    }

    public UserNotificationSettingsMetricsAcc createNonThreadSafeAccumulator() {
        return new UserNotificationSettingsMetricsAcc(false);
    }

    public void sendStats(UserNotificationSettingsMetricsAcc stats) {
        long now = System.currentTimeMillis();
        List<SolomonSensor> sensors = stats.getSensorValues()
                .map(e -> SolomonSensor.createAligned(e.getKey(), now, 1L, e.getValue()))
                .collect(Collectors.toList());
        solomonPushAPIService.pushMetrics(sensors, commonLabels);
    }

    @Required
    public void setSolomonPushAPIService(SolomonPushAPIService solomonPushAPIService) {
        this.solomonPushAPIService = solomonPushAPIService;
    }

    @Required
    public void setProject(String project) {
        this.project = project;
    }

    @Required
    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Required
    public void setService(String service) {
        this.service = service;
    }
}
