package ru.yandex.webmaster3.worker.download.links;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.yandex.webmaster3.core.util.functional.ThrowingConsumer;
import ru.yandex.webmaster3.storage.download.common.BrokenLinkSamplesMdsExportDescriptor;
import ru.yandex.webmaster3.storage.download.common.MdsExportTaskData;
import ru.yandex.webmaster3.storage.links.BrokenLinkSamplesService;
import ru.yandex.webmaster3.worker.download.AbstractMdsDataProvider;

import static ru.yandex.webmaster3.core.util.functional.ThrowingConsumer.rethrowingUnchecked;

/**
 * @author leonidrom
 */
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class BrokenLinkSamplesMdsDataProvider extends AbstractMdsDataProvider<BrokenLinkSamplesSpreadsheetRow> {
    private final BrokenLinkSamplesService brokenLinkSamplesService;

    @Override
    public void provide(MdsExportTaskData exportTaskData, ThrowingConsumer<BrokenLinkSamplesSpreadsheetRow,
            Exception> consumer) throws Exception {
        var exportDescriptor = (BrokenLinkSamplesMdsExportDescriptor)exportTaskData.getDescriptor();
        brokenLinkSamplesService.streamSamplesForLinkType(exportDescriptor.getHostId(), exportDescriptor.getLinkType(), s -> {
            var row = BrokenLinkSamplesSpreadsheetRow.fromBrokenLinkSample(s);
            rethrowingUnchecked(consumer).accept(row);
        });
    }

    @Override
    public Class<BrokenLinkSamplesSpreadsheetRow> getRowClass() {
        return BrokenLinkSamplesSpreadsheetRow.class;
    }
}
