package ru.yandex.webmaster3.worker.download.links;

import com.opencsv.bean.CsvBindByName;
import lombok.Data;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.webmaster3.core.download.MdsSerializable;
import ru.yandex.webmaster3.core.link.BrokenLinkSample;
import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;


/**
 * @author leonidrom
 */
@Row(colsOrder = {"From", "To", "Code", "Date"})
@Data
public class BrokenLinkSamplesSpreadsheetRow implements MdsSerializable {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern("dd.MM.yyyy");

    @CsvBindByName(column = "From")
    @Column(name = "From")
    private final String srcUrl;

    @CsvBindByName(column = "To")
    @Column(name = "To")
    private final String dstUrl;

    @CsvBindByName(column = "Code")
    @Column(name = "Code")
    private final int httpCode;

    @CsvBindByName(column = "Date")
    @Column(name = "Date")
    private final String linkDate;

    static BrokenLinkSamplesSpreadsheetRow fromBrokenLinkSample(BrokenLinkSample sample) {
        return new BrokenLinkSamplesSpreadsheetRow(sample.getSrcUrl(), sample.getDstUrl(), sample.getDstHttpCode(),
                DATE_FORMAT.print(sample.getLinkDate()));
    }
}
