package ru.yandex.webmaster3.worker.download.links;

import ru.yandex.webmaster3.core.download.GzipMdsSerializable;

public class LinkData implements GzipMdsSerializable {

    private final String key;
    private final String subKey;
    private final byte[] value;

    public LinkData(String key, String subKey, byte[] value) {
        this.key = key;
        this.subKey = subKey;
        this.value = value;
    }

    @Override
    public byte[] getValue() {
        return value;
    }

    public String getKey() {
        return key;
    }

    public String getSubKey() {
        return subKey;
    }
}
