package ru.yandex.webmaster3.worker.download.metrika;

import lombok.Data;
import ru.yandex.webmaster3.core.download.MdsSerializable;
import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;
import ru.yandex.webmaster3.storage.metrika.data.MetrikaCrawlSample;

/**
 * @author leonidrom
 */
@Row(colsOrder = {"Counter", "Domain", "Url", "Title"})
@Data
class MetrikaCrawlSamplesSpreadsheetRow implements MdsSerializable {
    @Column(name = "Domain")
    private final String domain;

    @Column(name = "Counter")
    private final long counterId;

    @Column(name = "Url")
    private final String url;

    @Column(name = "Title")
    private final String title;

    static MetrikaCrawlSamplesSpreadsheetRow fromMetrikaCrawlSample(MetrikaCrawlSample sample) {
        return new MetrikaCrawlSamplesSpreadsheetRow(
                sample.getDomain(), sample.getCounterId(), sample.getUrl(), sample.getTitle());
    }
}
