package ru.yandex.webmaster3.worker.download.searchquery;

import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.download.DownloadInfo;
import ru.yandex.webmaster3.storage.download.DownloadInfoYDao;
import ru.yandex.webmaster3.storage.download.DownloadStatus;
import ru.yandex.webmaster3.storage.download.searchquery.DownloadQueriesIndicatorStatisticTaskData;
import ru.yandex.webmaster3.storage.download.searchquery.QueriesExportService;
import ru.yandex.webmaster3.worker.ProcessingCountLimitedTask;

/**
 * Created by ifilippov5 on 09.03.17.
 */
@Category("searchquery")
public class DownloadStatisticAllQueriesOneIndicatorTask extends ProcessingCountLimitedTask<DownloadQueriesIndicatorStatisticTaskData> {
    private static final Logger log = LoggerFactory.getLogger(DownloadStatisticAllQueriesOneIndicatorTask.class);
    private DownloadStatisticRunnerService downloadStatisticRunnerService;
    private QueriesExportService queriesExportService;
    private DownloadInfoYDao downloadInfoYDao;

    @Override
    public Result run(DownloadQueriesIndicatorStatisticTaskData data) {
        byte[] statistics;
        try {
            statistics = queriesExportService.getAllQueriesIndicatorStatistics(
                    data.getHostId(),
                    data.getLocalDateFrom(),
                    data.getLocalDateTo(),
                    data.getRegionId(),
                    data.getRegionInclusion(),
                    data.getSpecialGroup(),
                    data.getIndicator(),
                    data.getDeviceType(),
                    data.getOrderByInd(),
                    data.getOrderDirectionInd(),
                    data.getPeriod(),
                    data.getExportFormat());
        } catch (Exception e) {
            log.error("Failed to get data from clickhouse", e);
            log.error("Download task with hostId = {} and hash = {} terminate in status Internal Error through " +
                            "exception during get data",
                    data.getHostId(), data.getHash());
            downloadInfoYDao.add(data.getHostId(), data.getHash(), DownloadInfo.error());
            throw new WebmasterException("Failed to get data",
                    new WebmasterErrorResponse.ClickhouseErrorResponse(getClass(), null, e), e);
        }

        downloadStatisticRunnerService.run(data, statistics);

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public Class<DownloadQueriesIndicatorStatisticTaskData> getDataClass() {
        return DownloadQueriesIndicatorStatisticTaskData.class;
    }

    @Required
    public void setDownloadStatisticRunnerService(DownloadStatisticRunnerService downloadRunnerService) {
        this.downloadStatisticRunnerService = downloadRunnerService;
    }

    @Required
    public void setQueriesExportService(QueriesExportService queriesExportService) {
        this.queriesExportService = queriesExportService;
    }

    @Required
    public void setDownloadInfoYDao(DownloadInfoYDao downloadInfoYDao) {
        this.downloadInfoYDao = downloadInfoYDao;
    }
}
