package ru.yandex.webmaster3.worker.download.turbo;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.util.functional.ThrowingConsumer;
import ru.yandex.webmaster3.storage.download.common.MdsExportTaskData;
import ru.yandex.webmaster3.storage.download.common.TurboAutoDeletedPagesMdsExportDescriptor;
import ru.yandex.webmaster3.storage.turbo.dao.autodelete.TurboAutoDeletedPagesCHDao;
import ru.yandex.webmaster3.worker.download.AbstractMdsDataProvider;

import static ru.yandex.webmaster3.core.util.functional.ThrowingConsumer.rethrowingUnchecked;

/**
 * ishalaru
 * 27.03.2020
 **/
@Slf4j
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component
public class TurboAutoDeletedPagesMdsDataProvider extends AbstractMdsDataProvider<TurboAutoDeletedPagesCsvRow> {

    public final TurboAutoDeletedPagesCHDao turboAutoDeletedPagesCHDao;

    @Override
    public void provide(MdsExportTaskData data, ThrowingConsumer<TurboAutoDeletedPagesCsvRow, Exception> consumer) throws Exception {
        TurboAutoDeletedPagesMdsExportDescriptor exportDescriptor = (TurboAutoDeletedPagesMdsExportDescriptor) data.getDescriptor();
        String domain = exportDescriptor.getDomain();
        List<String> urls = turboAutoDeletedPagesCHDao.getUrls(domain);
        urls.stream().map(TurboAutoDeletedPagesCsvRow::new).forEach(r -> rethrowingUnchecked(consumer).accept(r));
    }

    @Override
    public Class<TurboAutoDeletedPagesCsvRow> getRowClass() {
        return TurboAutoDeletedPagesCsvRow.class;
    }
}
