package ru.yandex.webmaster3.worker.download.turbo;

import com.opencsv.bean.CsvBindByName;
import lombok.AllArgsConstructor;
import lombok.Getter;
import ru.yandex.webmaster3.core.download.MdsSerializable;
import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;

@AllArgsConstructor
@Getter
@Row(colsOrder = {"domain", "url", "feed", "source", "isSearchable"})
public class TurboSearchUrlSampleCsvRow  implements MdsSerializable {

    @CsvBindByName
    @Column
    private final String domain;

    @CsvBindByName
    @Column
    private final String url;

    @CsvBindByName
    @Column
    private final String feed;

    @CsvBindByName
    @Column
    private final String source;

    @CsvBindByName
    @Column
    private final int isSearchable;
}

