package ru.yandex.webmaster3.worker.feeds.download;

import java.nio.charset.StandardCharsets;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import ru.yandex.webmaster3.core.download.GzipMdsSerializable;
import ru.yandex.webmaster3.core.download.MdsSerializable;
import ru.yandex.webmaster3.core.util.GzipUtils;
import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;

/**
 * Created by Oleg Bazdyrev on 18/01/2022.
 */
@Value
@Row(colsOrder = {"feed", "code", "severity", "line", "column", "url", "message", "context"})
public class FeedsAllErrorsCsvRow implements MdsSerializable {

    @Column
    @JsonProperty
    String feed;
    @Column
    @JsonProperty
    String code;
    @Column
    @JsonProperty
    String severity;
    @Column
    @JsonProperty
    Integer line;
    @Column
    @JsonProperty
    Integer column;
    @Column
    @JsonProperty
    String url;
    @Column
    @JsonProperty
    String message;
    @Column
    @JsonProperty
    String context;

}
